#ifndef __DMCI_H__
#define __DMCI_H__
/**
 *
 * \file       dmci.h
 * \brief      definitions for DMCI (standalone) operation support for the DM Input cards
 * \author     Larry Salant
 * \date       3/17/2009
 *
 */

////////////////////////////////////////////////////////////////////////////////
#include "dm_nutypedefs.h"

#define DMCI_MONITOR_TASK_PERIOD   50   // milliseconds
#define CRESNET_LINK_STATUS_BLINK             2000 // turn off after 2 sec of inactivity
#define ETHERNET_ACTIVITY_STATUS_BLINK        50 // blink rate for Ethernet Activity Status LED (ms)

// Slot ID - Port 1 config in Standalone mode (controls LED's on DMCI)
#define EXP_PORT1_STANDALONE 0x04 // Slot 3 is setup button
// Slot ID bits in Standalone mode
#define SLOT_ID_ETH_ACT_LED     0x01
#define SLOT_ID_ETH_LINK_LED    0x02
#define SLOT_ID_USB_CONSOLE_SW  0x04
#define SLOT_ID_USB_CONSOLE_LED 0x08
#define SLOT_ID_NOT_USED        0x10  // Pulled up

#define DEFAULT_DMCI_CRESNET_ADDRESS 0x96  // default cresnet address for DMCI
#define MIN_DMCI_CRESNET_ADDRESS     0x03
#define MAX_DMCI_CRESNET_ADDRESS     0xfe

#define DMCI_CARD_NAME_PREFIX   5

// Support Functions
void DMCIMonitorTask(void);
INT32 CresnetIDCmd(UINT32 ignore, char *cmd);
void DMCILedControl(UINT8 bLED, UINT8 bState);
UINT8 DMCIGetLinkStatus(void);

#ifdef __cplusplus
extern "C" void Ethernet_ActivityLED( void );
#else
void Ethernet_ActivityLED( void );
#endif

extern UINT8 StandAloneMode;
extern INT16 CresnetLinkTimer;
// I2C bus that the port expander for Slot ID;  This is needed so that the LED's on
// the DMCI can be set from common code
extern UINT8 gDMCIBus;

// project specific functions:
UINT8 IsSetupButtonPressed(void);

#endif  //__DMCI_H__

